<?php
/* --------------------------------------------------------------
   ApiMiddlewareRegistration.php 2020-10-19
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Application\Bootstrapper;

use Gambio\Api\Application\Middleware\ApiMiddlewareServiceProvider;
use Gambio\Api\Application\Middleware\AuthenticationMiddleware;
use Gambio\Api\Application\Middleware\RateLimitMiddleware;
use Gambio\Api\Application\Middleware\VersionsMiddleware;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Bootstrapper;
use RuntimeException;
use Slim\App as SlimApp;

/**
 * Class ApiMiddlewareRegistration
 *
 * @package Gambio\Api\Application\Bootstrapper
 */
class ApiMiddlewareRegistration implements Bootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $application->registerProvider(ApiMiddlewareServiceProvider::class);
        
        $slim = $this->getSlimApp($application);
        $slim->add(RateLimitMiddleware::class);
        $slim->add(AuthenticationMiddleware::class);
        $slim->add(VersionsMiddleware::class);
    }
    
    
    /**
     * @param Application $application
     *
     * @return SlimApp
     */
    private function getSlimApp(Application $application): SlimApp
    {
        if ($application->has(SlimApp::class) === false) {
            throw new RuntimeException('Slim app needs to be registered to register API middlewares.');
        }
        
        return $application->get(SlimApp::class);
    }
}